/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: TCP
 * Filename: FSMArrowPanel.java
 * Author: Gunter Weiss
 * Contents: Loads images and places these images in a panel
 * Last Changes: Gunter Weiss 23/4/97
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Color;
import java.awt.Canvas;

/******************************************************************************
* Class: FSMArrowPanel
* Description: places the TCP-Status in a panel
******************************************************************************/
public class FSMArrowCan extends Canvas {
  Image image;
  String statestring;
  String flag1 = "";
  String flag2 = "";
  int size,x1,x2,y1,y2;
  int dx,dy,dy2;
  int highlight;
  int direction;
  FSMWindow fsm_window;
  HTcpSegment segm, dummyseg;

  public FSMArrowCan ( FSMWindow fsm_window, int d1, int hl){
    this.fsm_window=fsm_window;
    dummyseg = new  HTcpSegment();
    changeSize( 1 , d1, dummyseg );

  }

/******************************************************************************
* Method: paint
* Description: draws the arrows.
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void paint( Graphics g ){
    switch (direction) {
    case 0: //Arrow right
            g. drawLine(0,dy2/2,dx,dy2/2);
            g. drawLine(0,dy2/2-1,dx,dy2/2-1);
            g. drawLine(dx,dy2/2-1,dx-5,(dy2/2)-4);
            g. drawLine(dx,dy2/2,dx-5,(dy2/2)+3);
	    g. drawString(flag1,5,9);
	    g. drawString(flag2,30,9);
            break;
    case 1: //Arrow right-down
            g. drawLine(0,0,dx,dy);
            g. drawLine(0,1,dx,dy+1);
            g. drawLine(dx,dy+1,dx-5,dy+1);//
            g. drawLine(dx,dy,dx-2,dy-5);
	    g. drawString(flag1,dx/4,10);
	    g. drawString(flag2,dx/4+10,20);
            break;
    case 2: //Arrow down
            g. drawLine(dx/2,0,dx/2,dy);
            g. drawLine(dx/2+1,0,dx/2+1,dy);
            g. drawLine(dx/2,dy,(dx/2)-3,dy-5);
            g. drawLine(dx/2+1,dy,(dx/2)+4,dy-5);
	    g. drawString(flag1,20,dy-25);
	    g. drawString(flag2,20,dy-15);
            break;
    case 3: //Arrow left down
            g. drawLine(dx,0,0,dy);
            g. drawLine(dx,1,0,dy+1);
            g. drawLine(0,dy,2,dy-5);
            g. drawLine(0,dy+1,+5,dy+1);
	    g. drawString(flag1,dx/2,10);
	    g. drawString(flag2,dx/2-10,20);
            break;
    case 4: //Arrow left
            g. drawLine(dx,dy2/2,0,dy2/2);
            g. drawLine(dx,dy2/2+1,0,dy2/2+1);
            g. drawLine(0,dy2/2,+5,(dy2/2)-3);
            g. drawLine(0,dy2/2+1,+5,(dy2/2)+4);
	    g. drawString(flag1,5,9);
	    g. drawString(flag2,30,9);
            break;
    case 5: // Arrow right down short
            g. drawLine(0,0,dx/2,dy2);
            g. drawLine(0,1,dx/2,dy2+1);
            break;
    case 6: // Arrow down short
            g. drawLine(dx/2,0,dx/2,dy2);
            g. drawLine(dx/2+1,0,dx/2+1,dy2);
            break;
    }
  }

/******************************************************************************
* Method: update
* Description:
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }
/******************************************************************************
* Method: changeSize
* Description: scales the Arrows and paints them
* Parameters: quality factor
* Return Value: none
******************************************************************************/
  public void changeSize( int size, int direction, HTcpSegment segm ){
    this .direction = direction;
    this .size = size;
    this .segm = segm;
    flag1 = "    ";
    flag2 = "    ";
    if (segm.SYN == 1) flag1 = "SYN";
    if (segm.FIN == 1) flag1 = "FIN";
    if (segm.RST == 1) flag1 = "RST";
    if (segm.URG == 1) flag1 = "URG";
    if (segm.PSH == 1) flag1 = "PSH";
    if (segm.ACK == 1) flag2 = "ACK";
    if( size == 1 ){
      dx = 100;  //factor 1
      dy = 60;
      dy2 = 20;
    }
    else if( size == 2 ){
      dx = 120;  //factor 1,25
      dy = 72;
      dy2 = 24;
    }
    else if( size == 3 ){
      dx = 160;  //factor 1,6
      dy = 96;
      dy2 = 32;
    }
    else if( size == 4 ){
      dx = 200;  //factor 2
      dy = 120;
      dy2 = 40;
    }
    switch (direction) {
        case 1:
        case 2:
        case 3:
            dy= dy;
            break;
        case 0:
        case 4:
        case 5:
        case 6:
            dy=dy2;
            break;
    }
    resize(dx,dy);
    dx = dx-4;
    dy = dy-4;
    dy2= dy2;//-4
    repaint();
  }
/******************************************************************************
* Method: changeSize
* Description: scales the Arrows and paints them
* Parameters: quality factor, direction
* Return Value: none
******************************************************************************/
  public void changeSize( int size, int direction ){
    this .direction = direction;
    this .size = size;
    if( size == 1 ){
      dx = 100;  //factor 1
      dy = 60;
      dy2 = 20;
    }
    else if( size == 2 ){
      dx = 120;  //factor 1,25
      dy = 72;
      dy2 = 24;
    }
    else if( size == 3 ){
      dx = 160;  //factor 1,6
      dy = 96;
      dy2 = 32;
    }
    else if( size == 4 ){
      dx = 200;  //factor 2
      dy = 120;
      dy2 = 40;
    }
    switch (direction) {
        case 1:
        case 2:
        case 3:
            dy= dy;
            break;
        case 0:
        case 4:
        case 5:
        case 6:
            dy=dy2;
            break;
    }
    resize(dx,dy);
    dx = dx-4;
    dy = dy-4;
    dy2= dy2;
    repaint();
  }
}












